/*
 * Decompiled with CFR 0.152.
 */
package com.netbay.poiexcel.controller;

import com.netbay.poiexcel.dto.Excel2csvReq;
import com.netbay.poiexcel.dto.Response;
import com.netbay.poiexcel.services.Excel2csvService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services"})
public class Exel2csvController {
    Logger logger = LoggerFactory.getLogger(Exel2csvController.class);
    @Autowired
    Excel2csvService excel2csvService;

    @PostMapping(value={"/excel2csv"}, consumes={"application/json"}, produces={"application/json"})
    public Response excel2csv(@RequestBody Excel2csvReq req) {
        UUID uuid = UUID.randomUUID();
        this.logger.info(uuid.toString() + " -> input parameter " + req.getExcelPath() + " , " + req.getCsvPath());
        Response res = new Response(500, "first stage");
        try {
            this.excel2csvService.toCsv(req.getExcelPath(), req.getCsvPath());
            res.setStatus(200);
            res.setMessage("successful");
            this.logger.info(uuid.toString() + " -> output parameter " + res.getStatus() + " , " + res.getMessage());
        }
        catch (Exception e) {
            res.setStatus(500);
            res.setMessage(e.getMessage());
            this.logger.info(uuid.toString() + " -> output parameter " + res.getStatus() + " , " + res.getMessage());
            this.logger.error(uuid + " -> ERROR : ", (Throwable)e);
            return res;
        }
        return res;
    }
}

