/*
 * Decompiled with CFR 0.152.
 */
package com.netbay.poiexcel.services;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class Excel2csvService {
    public void toCsv(String excelPath, String csvPath) throws Exception {
        List aList = this.readExcel(excelPath);
        Path path = Paths.get(csvPath, new String[0]);
        this.csvWriterOneByOne(aList, path);
    }

    private void csvWriterOneByOne(List<String[]> stringArray, Path path) throws Exception {
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(path.toString()), ',', '\"', '\"', "\r\n");
        for (String[] array : stringArray) {
            writer.writeNext(array, false);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> readExcel(String fileLocation) throws IOException {
        FileInputStream file = null;
        ArrayList<String[]> aList = new ArrayList<String[]>();
        File excelFile = new File(fileLocation);
        file = new FileInputStream(excelFile);
        try {
            Object workbook = null;
            workbook = excelFile.getName().endsWith(".xls") ? new HSSFWorkbook((InputStream)file) : new XSSFWorkbook((InputStream)file);
            Sheet sheet = workbook.getSheetAt(0);
            HashMap data = new HashMap();
            int i = 0;
            for (Row row : sheet) {
                data.put(i, new ArrayList());
                String[] str = new String[51];
                for (int x = 0; x < 51; ++x) {
                    String strValue;
                    Cell cell = row.getCell(x, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    DataFormatter formatter = new DataFormatter();
                    str[x] = strValue = formatter.formatCellValue(cell);
                }
                aList.add(str);
                ++i;
            }
        }
        finally {
            file.close();
        }
        return aList;
    }
}

