/*
 * Decompiled with CFR 0.152.
 */
package th.co.netbay.spnservice.autodraft.service;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import th.co.netbay.spnservice.autodraft.service.ValidateService;

@Service
public class CreateDraftImportService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ValidateService validateService;
    @Autowired
    Properties properties;
    @Autowired
    public Environment env;
    @Autowired
    RestTemplate restTemplate;
    private static final Logger logger = LogManager.getLogger(CreateDraftImportService.class);

    public void getWaitingDraft() {
        String waitingDraftDeclStmt = "SELECT referenceNo AS REFERENCE_NUMBER,ImDclCtrl AS IMDCLCTRL , declarationNo AS DECLARATION_NUMBER ,currencyCode AS CURRENCYCODE, arrivalDate AS ARRIVALDATE,cifValueBaht AS CIFBATH FROM importdeclarationcontrol imp WHERE imp.declStatus = 'WAITINGDRAFT' LIMIT 10";
        String URLSPN = this.env.getProperty("url.get.spn");
        String URLSPN_LOGIN = this.env.getProperty("url.get.spnlogin");
        String statusLogin = this.logInSPN(URLSPN_LOGIN);
        String errorLogin = "";
        if (statusLogin.equals("Invalid Username")) {
            errorLogin = "Y";
        }
        if (!errorLogin.equals("Y")) {
            List waitingDraftDeclList = this.jdbcTemplate.queryForList(waitingDraftDeclStmt);
            if (waitingDraftDeclList.size() != 0) {
                for (Map waitingDraftDecl : waitingDraftDeclList) {
                    String ImctrlId = waitingDraftDecl.get("IMDCLCTRL").toString();
                    String currencyCode = waitingDraftDecl.get("CURRENCYCODE").toString();
                    String arrivalDate = waitingDraftDecl.get("ARRIVALDATE").toString();
                    Object cifBath = waitingDraftDecl.get("CIFBATH");
                    String REFNO = waitingDraftDecl.get("REFERENCE_NUMBER").toString();
                    String rateStatus = this.getRate(currencyCode, arrivalDate, cifBath, ImctrlId);
                    String privilegeStatus = this.updatePrivilegeCode(ImctrlId);
                    if (!rateStatus.equals("Y") || !privilegeStatus.equals("Y")) continue;
                    String urlGetWaitingDraft = URLSPN + statusLogin + "&SELITEM=ImDclCtrl:" + ImctrlId + "&ImDclCtrl=" + ImctrlId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=WORKSPACE&SUB_ACTION=RECALCULATION";
                    ResponseEntity responseWaitingList = this.restTemplate.getForEntity(urlGetWaitingDraft, String.class, new Object[0]);
                    HttpStatus statusCode = responseWaitingList.getStatusCode();
                    logger.info("statusCode :" + statusCode);
                    if (!statusCode.toString().equals("200 OK") && !statusCode.toString().equals("301 MOVED_PERMANENTLY")) continue;
                    logger.info("Recalculation Complete : " + REFNO);
                    this.updateTotalTax(ImctrlId, statusLogin, URLSPN);
                    this.updateCifTH(ImctrlId, statusLogin, URLSPN);
                    this.updateCifForeign(ImctrlId, statusLogin, URLSPN);
                    this.updatetotalInvoice(ImctrlId, statusLogin, URLSPN);
                    this.updateTotalPaymentAmount(ImctrlId, statusLogin, URLSPN);
                    this.updateDeposit(ImctrlId, statusLogin, URLSPN);
                    this.updateGuaranteeMethod(ImctrlId, statusLogin, URLSPN);
                    String paramerStatus = this.validateService.getParameter();
                    if (paramerStatus.equals("Y")) {
                        this.updateDeclDraft(ImctrlId);
                        String statusValidate = this.validateService.checkValidate(ImctrlId, statusLogin);
                        if (!statusValidate.equals("Y")) continue;
                        logger.info("Validate Complete : " + REFNO);
                        continue;
                    }
                    this.updateDeclDraft(ImctrlId);
                }
            } else {
                logger.info("No Data reference status WAITING DRAFT");
            }
        } else {
            logger.info("Login Status" + statusLogin);
        }
    }

    public String logInSPN(String urlSPN) {
        String status;
        String getUcodeSpnServiceUser = "SELECT UCODE , UID FROM tab_user WHERE USERNAME = 'spnservice' AND PASSWORD = 'spnservice' ";
        List getUcodeList = this.jdbcTemplate.queryForList(getUcodeSpnServiceUser);
        if (getUcodeList.size() == 1) {
            String ucode = ((Map)getUcodeList.get(0)).get("UCODE").toString();
            String uid = ((Map)getUcodeList.get(0)).get("UID").toString();
            status = "UID=" + uid + "&UCODE=" + ucode;
        } else {
            status = "Invalid Username";
        }
        return status;
    }

    public String getRate(String currencyCode, String arrivalDate, Object cifBath, String ImctrlId) {
        String getRateDecl = "SELECT baht AS BATH,rate AS UNIT  FROM conf_exchangerate WHERE currency = '" + currencyCode + "' and ('" + arrivalDate + "' between exdate and finishdate)";
        List rateList = this.jdbcTemplate.queryForList(getRateDecl);
        if (rateList.size() != 0) {
            Double BATH = (Double)((Map)rateList.get(0)).get("BATH");
            Double UNIT = (Double)((Map)rateList.get(0)).get("UNIT");
            Double RATE = BATH / UNIT;
            Double cifBaths = Double.parseDouble((String)cifBath);
            Double cifValueForeign = cifBaths / RATE;
            int updateCifStatus = this.updateCifDecl(String.format("%.2f", cifValueForeign), ImctrlId);
            if (updateCifStatus != 0) {
                return "Y";
            }
            return "N";
        }
        return "N";
    }

    public int updateCifDecl(String cifValueForeign, String declId) {
        String updateCifForeignDecl = "UPDATE importdeclarationcontrol SET cifValueForeign = '" + cifValueForeign + "' WHERE ImDclCtrl = '" + declId + "'";
        return this.jdbcTemplate.update(updateCifForeignDecl);
    }

    public String updateCifTH(String declId, String sessions, String urlSpn) {
        String statusCIFTH = "";
        String urlGetcifValueBaht = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&rsCifTHBath=Y";
        String updateCIFTH = "UPDATE importdeclarationcontrol SET cifValueBaht = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseCifTH = this.restTemplate.getForEntity(urlGetcifValueBaht, String.class, new Object[0]);
        if (responseCifTH.getStatusCodeValue() == 200) {
            String CIFvalueTH = (String)responseCifTH.getBody();
            int ststusUpdateTax = this.jdbcTemplate.update(updateCIFTH, new Object[]{CIFvalueTH});
            statusCIFTH = ststusUpdateTax != 0 ? "Y" : "N";
        }
        return statusCIFTH;
    }

    public String updateCifForeign(String declId, String sessions, String urlSpn) {
        String statusCIFFR = "";
        String urlGetcifValueForeign = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&rsCifForeign=Y";
        String updateCIFForeign = "UPDATE importdeclarationcontrol SET cifValueForeign = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseCifTH = this.restTemplate.getForEntity(urlGetcifValueForeign, String.class, new Object[0]);
        if (responseCifTH.getStatusCodeValue() == 200) {
            String CIFvalueTH = (String)responseCifTH.getBody();
            int ststusUpdateTax = this.jdbcTemplate.update(updateCIFForeign, new Object[]{CIFvalueTH});
            statusCIFFR = ststusUpdateTax != 0 ? "Y" : "N";
        }
        return statusCIFFR;
    }

    public String updatetotalInvoice(String declId, String sessions, String urlSpn) {
        String statusTotalInv = "";
        String getInvoiceByDecl = "SELECT ImDclCtrlInv as 'IMDCLCTRLINV' FROM importdeclarationcontrolinvoice WHERE HID = '" + declId + "' ";
        String updateTotalInvoice = "UPDATE importdeclarationcontrolinvoice SET totalInvoice = ?  WHERE ImDclCtrlInv = ? ";
        List InvoiceList = this.jdbcTemplate.queryForList(getInvoiceByDecl);
        if (InvoiceList.size() != 0) {
            for (Map invoiceByDecl : InvoiceList) {
                String ImDclCtrlInvId = invoiceByDecl.get("IMDCLCTRLINV").toString();
                String urlTotalInvoice = urlSpn + sessions + "&SELITEM=ImDclCtrlInv:" + ImDclCtrlInvId + "&SERVICENAME=IMINVOICECONTROL&ACTION=EDIT&SPNSERVICE=Y";
                ResponseEntity responseTotalInv = this.restTemplate.getForEntity(urlTotalInvoice, String.class, new Object[0]);
                if (responseTotalInv.getStatusCodeValue() != 200) continue;
                String totalInvoice = (String)responseTotalInv.getBody();
                int ststusUpdateTotalInv = this.jdbcTemplate.update(updateTotalInvoice, new Object[]{totalInvoice, ImDclCtrlInvId});
                if (ststusUpdateTotalInv != 0) {
                    statusTotalInv = "Y";
                    continue;
                }
                statusTotalInv = "N";
            }
        }
        return statusTotalInv;
    }

    public String updatePrivilegeCode(String declId) {
        String getItemDecl = "SELECT tariffCode AS TARIFF,tariffSequence AS SEQCODE,ImDclDt AS IMDCLDT FROM importdeclarationdetail WHERE HID = '" + declId + "' ";
        String getPrivilegeCode = "SELECT privilege AS PRIVILEGECODE FROM master_imduty WHERE tariffclas = ? AND tariffseq = ? ";
        String updatePrivilege = "UPDATE importdeclarationdetail SET privilegeCode = ? WHERE ImDclDt = ?";
        List itemListByDecl = this.jdbcTemplate.queryForList(getItemDecl);
        String updatStatus = "";
        for (Map itemList : itemListByDecl) {
            String privilegeCode;
            String itemId = itemList.get("IMDCLDT").toString();
            String tariffCode = itemList.get("TARIFF").toString();
            String sequenceCode = itemList.get("SEQCODE").toString();
            List privilegeListByItem = this.jdbcTemplate.queryForList(getPrivilegeCode, new Object[]{tariffCode, sequenceCode});
            if (privilegeListByItem.size() == 0) {
                privilegeCode = "";
                logger.info("Case privilege not found, ImDclDt:" + itemId + ", tariffCode:" + tariffCode + ", sequence:" + sequenceCode);
            } else {
                privilegeCode = ((Map)privilegeListByItem.get(0)).get("PRIVILEGECODE").toString();
                if (privilegeCode.equals("")) {
                    logger.info("Case privilege is blank, ImDclDt:" + itemId + ", tariffCode:" + tariffCode + ", sequence:" + sequenceCode);
                }
            }
            int updatePriStatus = this.jdbcTemplate.update(updatePrivilege, new Object[]{privilegeCode, itemId});
            if (updatePriStatus != 0) {
                updatStatus = "Y";
                continue;
            }
            updatStatus = "N";
        }
        return updatStatus;
    }

    public String updateDeclDraft(String declId) {
        String updatStatus = "";
        String updateDraftStatus = "UPDATE importdeclarationcontrol SET declStatus = ''  WHERE ImDclCtrl = '" + declId + "' ";
        int updateStatement = this.jdbcTemplate.update(updateDraftStatus);
        updatStatus = updateStatement != 0 ? "Y" : "N";
        return updatStatus;
    }

    public String updateTotalTax(String declId, String sessions, String urlSpn) {
        String statusTotalTax = "";
        String urlGetTotalTax = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&rsTotalTax=Y";
        String updateTotalTax = "UPDATE importdeclarationcontrol SET totalTax = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseTotalTax = this.restTemplate.getForEntity(urlGetTotalTax, String.class, new Object[0]);
        if (responseTotalTax.getStatusCodeValue() == 200) {
            String totalTax = (String)responseTotalTax.getBody();
            int ststusUpdateTax = this.jdbcTemplate.update(updateTotalTax, new Object[]{totalTax});
            statusTotalTax = ststusUpdateTax != 0 ? "Y" : "N";
        }
        return statusTotalTax;
    }

    public String updateTotalPaymentAmount(String declId, String sessions, String urlSpn) {
        String statusTotalPM = "";
        String urlGetTotalPMAmount = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&rsTotalPaymentAmount=Y";
        String updateTotalPM = "UPDATE importdeclarationcontrol SET totalPaymentAmount = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseTotalPM = this.restTemplate.getForEntity(urlGetTotalPMAmount, String.class, new Object[0]);
        if (responseTotalPM.getStatusCodeValue() == 200) {
            String totalPMamount = (String)responseTotalPM.getBody();
            int ststusUpdateTax = this.jdbcTemplate.update(updateTotalPM, new Object[]{totalPMamount});
            statusTotalPM = ststusUpdateTax != 0 ? "Y" : "N";
        }
        return statusTotalPM;
    }

    public String updateDeposit(String declId, String sessions, String urlSpn) {
        String statusTotalDeposit = "";
        String urlGetTotalDeposit = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&rstotalDepositDetail=Y";
        String updateTotalDeposit = "UPDATE importdeclarationcontrol SET totalDeposit = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseTotalPM = this.restTemplate.getForEntity(urlGetTotalDeposit, String.class, new Object[0]);
        if (responseTotalPM.getStatusCodeValue() == 200) {
            String totalDeposit = (String)responseTotalPM.getBody();
            int ststusUpdateDP = this.jdbcTemplate.update(updateTotalDeposit, new Object[]{totalDeposit});
            statusTotalDeposit = ststusUpdateDP != 0 ? "Y" : "N";
        }
        return statusTotalDeposit;
    }

    public String updateGuaranteeMethod(String declId, String sessions, String urlSpn) {
        String statusGMethod = "";
        String urlGetGuaranteeMethod = urlSpn + sessions + "&SELITEM=ImDclCtrl:" + declId + "&SERVICENAME=IMPORTDECLARATIONCONTROL&ACTION=EDIT&SPNSERVICE=Y&guaranteeMethodRS=Y";
        String updateTotalPM = "UPDATE importdeclarationcontrol SET guaranteeMethod = ?  WHERE ImDclCtrl = '" + declId + "' ";
        ResponseEntity responseGuarantee = this.restTemplate.getForEntity(urlGetGuaranteeMethod, String.class, new Object[0]);
        if (responseGuarantee.getStatusCodeValue() == 200) {
            String totalPMamount = (String)responseGuarantee.getBody();
            int ststusUpdateTax = this.jdbcTemplate.update(updateTotalPM, new Object[]{totalPMamount});
            statusGMethod = ststusUpdateTax != 0 ? "Y" : "N";
        }
        return statusGMethod;
    }
}

